#! /bin/bash

declare -a gpu_list=(0 1 0 1 0)
declare -a cpu_list=("0-7" "8-15" "16-23" "24-31" "31-40")

config_root=../config/pubmed/SDMP/inductive_ratio

root_result_path=../result/pubmed_SAGE_SDMP_ind_ratio
GNN_target_path=../result/pubmed/SAGE

host_name=`uname -n`


declare -a config_name=("pubmed_SDMP_SAGE_indtrain_02_theta_dense_k_1_3_h_dense_3.yml" "pubmed_SDMP_SAGE_indtrain_04_theta_dense_k_1_3_h_dense_3.yml" "pubmed_SDMP_SAGE_indtrain_06_theta_dense_k_1_3_h_dense_3.yml" "pubmed_SDMP_SAGE_indtrain_08_theta_dense_k_1_3_h_dense_3.yml")

for ((idx=0; idx<${#config_name[@]}; ++idx)); do
    data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
    cur_result_path=${host_name}_${data_time}
    taskset -c ${cpu_list[$idx]} python ../main_gen_SDMP.py --data ../dataset --config ${config_root}/${config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${root_result_path}/${cur_result_path}" --gnn $GNN_target_path > /dev/null &
    pids[$idx]=$!
    sleep 1
done # end of for over train confi
echo "Done this round of start!"
for pid in ${pids[*]}; do
    wait $pid
done
